* Definicia indexovych mnozin
 Set i /1*10/
    m /1*2/
    k /1*5000/
    n /1*5000/
    t /A,B/
    s /GJM,ALT/;

    alias(i,j);
    alias(m,m1);

$onempty

Set subi(i) //
    subj(j) //

* Definicia parameterov
Parameter A1(i,j),B1(i,j),y1(i),x1(j),u1(i),v1(j),
          A0(i,j),B0(i,j),y0(i),x0(j),u0(i),v0(j),
          MAD_A(n,s,t),SEM_A(n,s,t),
          MAD_B(n,s,t),SEM_B(n,s,t),
          MaxPE(n,s,t),MAPE(n,s,t),
          GOF_A(n,s,t),GOF_B(n,s,t),
          CORR_A(n,s,t),CORR_B(n,s,t),
          mean_A1_HAT(s,t),mean_A1,
          mean_B1_HAT(s,t),mean_B1,
          mean0(n),mean1(n),
          stddev0(n),stddev1(n);

parameter lamahe(n,s,t),lamahe2(n,s,t),lamahe3(i,j);

Scalar G1,F,N1,N2,N5;
    N1=sum((i,j), 1);
    N2=sum(n, 1);
    N5=sum(m, 1);

Parameter N4(i,j);

Parameter Z_GJM(i,j,m),Z_ALT(i,j,m);

Parameter zero(i,j);
    zero(i,j)=0;

* Definicia premennych a rovnic
Variables
    lambda(i)
    mi(j)
    gamma(i,j)
    ni(i,j)
    H       entropy;

Equations
    obj_gjm    define objective function - golan & judge & miller
    obj_alt    define objective function - alternative ;

    obj_gjm..    H =e= sum(i, lambda(i)*u1(i))
                     + sum(j, mi(j))
                     + sum((i,j), log(sum(m, exp(-(lambda(i)*v1(j)+mi(j)+ni(i,j)$(subi(i)$(subj(j))))*Z_GJM(i,j,m)))));

obj_alt..    H =e= sum(i, lambda(i)*u1(i))
                     + sum(j, mi(j)*v1(j))
                     + sum((i,j)$(N4(i,j) = N5), gamma(i,j))
                     + log(sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda(i)*G1-mi(j)*G1-ni(i,j)*zero(i,j)-(gamma(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))));

Model IO_GJM /obj_gjm/ ;
Model IO_ALT /obj_alt/ ;

option NLP=CONOPT;

Parameter omega1(i,j),omega2,p(i,j,m),
          A1_HAT(i,j,s,t),B1_HAT(i,j,s,t),
          E_A(i,j,s,t),
          E_B(i,j,s,t),
          P_B(i,j,s,t);

*loop(k,
*    B0(i,j)=uniform(0,10);
*    y0(i)=uniform(0,10);
*    B1(i,j)=abs(normal(1.3,0.85))*B0(i,j);
*    y1(i)=abs(normal(1.3,0.85))*y0(i);
*    );

* MC simulacie
loop(n,

    B0(i,j)=uniform(0,10);
    y0(i)=uniform(0,10);
    u0(i)=sum(j, B0(i,j));
    v0(j)=sum(i, B0(i,j));

    x0(i)=u0(i)+y0(i);

    loop(i,
         if (v0(i)>=x0(i),
            x0(i)=v0(i)+y0(i);
            y0(i)=x0(i)-u0(i);
            );
         );

    A0(i,j)=B0(i,j)/x0(j);

    B1(i,j)=abs(normal(1.3,0.65))*B0(i,j);
    y1(i)=abs(normal(1.3,0.65))*y0(i);
    u1(i)=sum(j, B1(i,j));
    v1(j)=sum(i, B1(i,j));

    x1(i)=u1(i)+y1(i);

    loop(i,
         if (v1(i)>=x1(i),
            x1(i)=v1(i)+y1(i);
            y1(i)=x1(i)-u1(i);
            );
         );

    A1(i,j)=B1(i,j)/x1(j);

    G1=sum(j, u1(j));

    F=G1/20;
*    F=1;
    G1=G1/F;

    v1(j)=v1(j)/F;
    u1(i)=u1(i)/F;

    Z_GJM(i,j,'1') = 0;
    Z_GJM(i,j,'2') = 1;

    Z_ALT(i,j,m) = Z_GJM(i,j,m);

    N4(i,j)=sum(m$(Z_ALT(i,j,m) ne 0), 1);

    lambda.l(i) = 0;
    mi.l(j) = 0;
    gamma.l(i,j) = 0;
    ni.l(i,j) = 0;

    solve IO_GJM using NLP minimizing H;

       omega1(i,j)=sum(m, exp(-(lambda.l(i)*v1(j)+mi.l(j)+ni.l(i,j)$(subi(i)$(subj(j))))*Z_GJM(i,j,m)));
       p(i,j,m)=exp(-(lambda.l(i)*v1(j)+mi.l(j)+ni.l(i,j)$(subi(i)$(subj(j))))*Z_GJM(i,j,m))/omega1(i,j);
       A1_HAT(i,j,'GJM','A')=F*v1(j)/x1(j)*sum(m, Z_GJM(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'GJM','A')=A1_HAT(i,j,'GJM','A')*x1(j);

    lambda.l(i) = 0;
    mi.l(j) = 0;
    gamma.l(i,j) = 0;
    ni.l(i,j) = 0;

    solve IO_ALT using NLP minimizing H;

       omega2=sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda.l(i)*G1-mi.l(j)*G1-ni.l(i,j)*zero(i,j)-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5)));
       p(i,j,m)$(Z_ALT(i,j,m) ne 0)=exp(-log(Z_ALT(i,j,m))-lambda.l(i)*G1-mi.l(j)*G1-ni.l(i,j)*zero(i,j)-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))/omega2;
       p(i,j,m)$(Z_ALT(i,j,m) = 0)=1-sum(m1, p(i,j,m1)$(Z_ALT(i,j,m1) ne 0));
       A1_HAT(i,j,'ALT','A')=F*G1/x1(j)*sum(m, Z_ALT(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'ALT','A')=A1_HAT(i,j,'ALT','A')*x1(j);

    Z_GJM(i,j,'1')=max(0,(v1(j)-(G1-u1(i)))/v1(j));
    Z_GJM(i,j,'2')=min(1,v1(j)/u1(i))*u1(i)/v1(j);

    Z_ALT(i,j,'1')=max(0,(v1(j)-(G1-u1(i)))/G1);
    Z_ALT(i,j,'2')=min(u1(i)/G1,v1(j)/G1);

    N4(i,j)=sum(m$(Z_ALT(i,j,m) ne 0), 1);

    lambda.l(i) = 0;
    mi.l(j) = 0;
    gamma.l(i,j) = 0;
    ni.l(i,j) = 0;

    solve IO_GJM using NLP minimizing H;

       omega1(i,j)=sum(m, exp(-(lambda.l(i)*v1(j)+mi.l(j)+ni.l(i,j)$(subi(i)$(subj(j))))*Z_GJM(i,j,m)));
       p(i,j,m)=exp(-(lambda.l(i)*v1(j)+mi.l(j)+ni.l(i,j)$(subi(i)$(subj(j))))*Z_GJM(i,j,m))/omega1(i,j);
       A1_HAT(i,j,'GJM','B')=F*v1(j)/x1(j)*sum(m, Z_GJM(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'GJM','B')=A1_HAT(i,j,'GJM','B')*x1(j);

    lambda.l(i) = 0;
    mi.l(j) = 0;
    gamma.l(i,j) = 0;
    ni.l(i,j) = 0;

    solve IO_ALT using NLP minimizing H;

       omega2=sum((i,j,m)$(Z_ALT(i,j,m) ne 0), exp(-lambda.l(i)*G1-mi.l(j)*G1-ni.l(i,j)*zero(i,j)-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5)));
       p(i,j,m)$(Z_ALT(i,j,m) ne 0)=exp(-log(Z_ALT(i,j,m))-lambda.l(i)*G1-mi.l(j)*G1-ni.l(i,j)*zero(i,j)-(gamma.l(i,j)/Z_ALT(i,j,m))$(N4(i,j) = N5))/omega2;
       p(i,j,m)$(Z_ALT(i,j,m) = 0)=1-sum(m1, p(i,j,m1)$(Z_ALT(i,j,m1) ne 0));
       A1_HAT(i,j,'ALT','B')=F*G1/x1(j)*sum(m, Z_ALT(i,j,m)*p(i,j,m));
       B1_HAT(i,j,'ALT','B')=A1_HAT(i,j,'ALT','B')*x1(j);

       E_A(i,j,s,t) = A1_HAT(i,j,s,t)-A1(i,j);
       E_B(i,j,s,t) = B1_HAT(i,j,s,t)-B1(i,j);
       P_B(i,j,s,t)$B1(i,j) = abs(E_B(i,j,s,t))/B1(i,j);

       MAD_A(n,s,t) = sum((i,j), abs(E_A(i,j,s,t)))/N1;
       SEM_A(n,s,t) = sum((i,j), power(E_A(i,j,s,t),2))/N1;
       GOF_A(n,s,t) = sum((i,j), power(E_A(i,j,s,t),2)/(N1*A1_HAT(i,j,s,t)));
       mean_A1_HAT(s,t)=sum((i,j), A1_HAT(i,j,s,t))/N1;
       mean_A1=sum((i,j), A1(i,j))/N1;
       CORR_A(n,s,t) = (sum((i,j),(A1_HAT(i,j,s,t)-mean_A1_HAT(s,t))*(A1(i,j)-mean_A1))/N1)/
         ((sum((i,j),power(A1_HAT(i,j,s,t)-mean_A1_HAT(s,t),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5;

       MAD_B(n,s,t) = sum((i,j), abs(E_B(i,j,s,t)))/N1;
       SEM_B(n,s,t) = sum((i,j), power(E_B(i,j,s,t),2))/N1;
       GOF_B(n,s,t) = sum((i,j), power(E_B(i,j,s,t),2)/(N1*B1_HAT(i,j,s,t)));
       mean_B1_HAT(s,t)=sum((i,j), B1_HAT(i,j,s,t))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B(n,s,t) = (sum((i,j),(B1_HAT(i,j,s,t)-mean_B1_HAT(s,t))*(B1(i,j)-mean_B1))/N1)/
         ((sum((i,j),power(B1_HAT(i,j,s,t)-mean_B1_HAT(s,t),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5;

       MaxPE(n,s,t) = smax((i,j), P_B(i,j,s,t));
       MAPE(n,s,t) = sum((i,j), P_B(i,j,s,t))/N1;

    mean0(n)=sum((i,j), b0(i,j))/N1;
    mean1(n)=sum((i,j), b1(i,j))/N1;
    stddev0(n)=sum((i,j), power((b0(i,j)-mean0(n)),2))/N1;
    stddev1(n)=sum((i,j), power((b1(i,j)-mean1(n)),2))/N1;

   );

* Vypocet parametrov
Parameter MAD_A_AVG(s,t),SEM_A_AVG(s,t),
          MAD_B_AVG(s,t),SEM_B_AVG(s,t),
          MaxPE_AVG(s,t),MAPE_AVG(s,t),
          GOF_A_AVG(s,t),GOF_B_AVG(s,t),
          CORR_A_AVG(s,t),CORR_B_AVG(s,t),
          mean0_avg,mean1_avg,
          stddev0_avg,stddev1_avg;

   MAD_A_AVG(s,t)=sum(n, MAD_A(n,s,t))/N2;
   SEM_A_AVG(s,t)=sum(n, SEM_A(n,s,t))/N2;
   GOF_A_AVG(s,t)=sum(n, GOF_A(n,s,t))/N2;
   CORR_A_AVG(s,t)=sum(n, CORR_A(n,s,t))/N2;

   MAD_B_AVG(s,t)=sum(n, MAD_B(n,s,t))/N2;
   SEM_B_AVG(s,t)=sum(n, SEM_B(n,s,t))/N2;
   GOF_B_AVG(s,t)=sum(n, GOF_B(n,s,t))/N2;
   CORR_B_AVG(s,t)=sum(n, CORR_B(n,s,t))/N2;

   MaxPE_AVG(s,t)=sum(n, MaxPE(n,s,t))/N2;
   MAPE_AVG(s,t)=sum(n, MAPE(n,s,t))/N2;

   mean0_avg=sum(n, mean0(n))/N2;
   mean1_avg=sum(n, mean1(n))/N2;

   stddev0_avg=sum(n, stddev0(n))/N2;
   stddev1_avg=sum(n, stddev1(n))/N2;

option decimals = 5

Display MAD_A_AVG,SEM_A_AVG,
        MAD_B_AVG,SEM_B_AVG,
        MaxPE_AVG,MAPE_AVG,
        GOF_A_AVG,GOF_B_AVG,
        CORR_A_AVG,CORR_B_AVG,
        mean0_avg,mean1_avg,
        stddev0_avg,stddev1_avg;